<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('product_ads_selected_attributes', function (Blueprint $table) {
            $table->id();
            // Relation
            $table->unsignedBigInteger('product_id');
            $table->foreign('product_id')->references('id')->on('products_ads')->onDelete("cascade")->onUpdate('cascade');
            // Relation
            $table->unsignedBigInteger('attr_id');
            $table->foreign('attr_id')->references('id')->on('product_attributes')->onDelete("cascade")->onUpdate('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('product_ads_selected_attributes');
    }
};
